
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Jan 13 14:18:07 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file holds the c code of the OAEP functions as described 
   *	in the specs of PKCS#1 Ver 1.5 and 2.1
   *
   *  \version CRYS_RSA_OAEP.c#1:csrc:2
   *  \author ohads
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/
#include "DX_VOS_Mem.h"
#include "CRYS.h"
#include "CRYS_RSA_error.h"
#include "CRYS_RND_error.h"
#include "CRYS_HASH_error.h"
#include "PLAT_SystemDep.h"
#include "dx_hw_defs.h"
#include "crys_host_op_code.h"

/************************ Defines ******************************/


/************************ Enums ******************************/


/************************ Typedefs ******************************/


/************************ Global Data ******************************/


/************* Private function prototype ****************/


#if !defined(_INTERNAL_CRYS_NO_RSA_ENCRYPT_SUPPORT) && !defined(_INTERNAL_CRYS_NO_RSA_VERIFY_SUPPORT)
/**********************************************************************************************************/

/**
   @brief
   RSA_SCHEMES_Encrypt implements the RSAES-OAEP algorithm as defined
   in PKCS#1 v2.1 8.1 and in PKCS#1 v1.5 8.1

   This function combines the RSA encryption primitive and the
   EME-OAEP encoding method, to provide an RSA-based encryption
   method that is semantically secure against adaptive
   chosen-ciphertext attacks. For more details, please refere to
   the PKCS#1 standard.

   @param[in] PubKey_ptr - Pointer to the public key data structure.
   @param[in] PrimeData_ptr - Pointer to a CRYS_RSAPrimeData_t which is used for the 
   							Encryption operation
   @param[in] hashFunc - The hash function to be used. Currently
                         only CRYS_PKCS1_SHA1 is supported. The
                         other hash functions recommended by PKCS#1
                         v2.1 are SHA-256/284/512.
   @param[in] L - The label input. relevant for PKCS#1 Ver2.1
                  Version 2.1 of the standard defines the default value for L as the empty string, 
   @param[in] Llen - The label length. relevant for PKCS#1 Ver2.1
                  Version 2.1 of the standard defines the default value for Llen as zero, 
   @param[in] MGF - the mask generation function. PKCS#1 v2.1
                    defines MGF1, so the only value allowed here is CRYS_PKCS1_MGF1.
   @param[in] Data_ptr - Pointer to the data to encrypt.
   @param[in] DataSize - The size, in bytes, of the data to
                         encrypt. \note Must be <= (modulus_size - 2*Hash_output_length - 2).

   @param[out] Output_ptr - Pointer to the encrypted data, the buffer
                            must be at least PubKey_ptr->N.len
                            bytes long (that is, the size of the
                            modulus, in bytes).

   @return CRYSError_t - CRYS_OK, CRYS_BAD_PARAM, CRYS_OUT_OF_RANGE
*/

CEXPORT_C CRYSError_t _DX_RSA_SCHEMES_Encrypt(CRYS_RSAUserPubKey_t *UserPubKey_ptr,
                                    CRYS_RSAPrimeData_t			   *PrimeData_ptr,
                                    CRYS_RSA_HASH_OpMode_t		   hashFunc,
                                    DxUint8_t					   *L,
                                    DxUint16_t					   Llen,
                                    CRYS_PKCS1_MGF_t			   MGF,
                                    DxUint8_t					   *DataIn_ptr,
                                    DxUint16_t					   DataInSize,
                                    DxUint8_t					   *Output_ptr,
                                    CRYS_PKCS1_version			   PKCS1_ver)
				  
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_ENC_OP_CODE, 10,
	   							 /* PARAMETERS: */
								 UserPubKey_ptr,
								 PrimeData_ptr,
								 hashFunc,
								 L, Llen, 
								 MGF,
								 DataIn_ptr, DataInSize,
								 Output_ptr,
								 PKCS1_ver );

}/* END OF _DX_RSA_SCHEMES_Encrypt */				  
#endif /*!defined(_INTERNAL_CRYS_NO_RSA_ENCRYPT_SUPPORT) && !defined(_INTERNAL_CRYS_NO_RSA_VERIFY_SUPPORT)*/

#if !defined(_INTERNAL_CRYS_NO_RSA_DECRYPT_SUPPORT) && !defined(_INTERNAL_CRYS_NO_RSA_SIGN_SUPPORT)
/**********************************************************************************************************/
/**
   @brief
   RSA_SCHEMES_Decrypt implements the RSAES-OAEP algorithm as defined
   in PKCS#1 v2.1 8.1 and in PKCS#1 v1.5

   This function combines the RSA decryption primitive and the
   EME-OAEP encoding method, to provide an RSA-based decryption
   method that is semantically secure against adaptive
   chosen-ciphertext attacks. For more details, please refere to
   the PKCS#1 standard.

   @param[in] UserPrivKey_ptr - Pointer to the private key data
                            structure. \note The representation
                            (pair or quintiple) and hence the
                            algorithm (CRT or not) is determined
                            by the Private Key data
                            structure. Using CRYS_Build_PrivKey
                            or CRYS_Build_PrivKeyCRT determines
                            which algorithm will be used.
                            
   @param[in] PrimeData_ptr - Pointer to a CRYS_RSAPrimeData_t which is used for the 
   							Encryption operation
   							                            
   @param[in] hashFunc - The hash function to be used. Currently
                         only CRYS_PKCS1_SHA1 is supported. The
                         other hash functions recommended by PKCS#1
                         v2.1 are SHA-256/384/512.
   @param[in] L - The label input. relevant for PKCS#1 Ver2.1
                  Version 2.1 of the standard defines the default value for L as the empty string, 
   @param[in] Llen - The label length. relevant for PKCS#1 Ver2.1
                  Version 2.1 of the standard defines the default value for Llen as zero, 
   @param[in] MGF - the mask generation function. PKCS#1 v2.1
                    defines MGF1, so the only value allowed here is CRYS_PKCS1_MGF1.
   @param[in] Data_ptr - Pointer to the data to decrypt.
   @param[in] DataSize - The size, in bytes, of the data to
                         decrypt. \note Must be <= the size of the modulus.

   @param[out] Output_ptr - Pointer to the decrypted data, the buffer
                            must be at least PrivKey_ptr->N.len
                            bytes long (that is, the size of the
                            modulus, in bytes).

   @param[in/out] OutputSize_ptr - The size of the Output_ptr buffer [bytes].
                                   The input size value must be at least the size of the modulus 
                                   This value is updated with the actual number 
                                   of bytes that are loaded to Output_ptr buffer

   @return CRYSError_t - CRYS_OK, CRYS_BAD_PARAM, CRYS_OUT_OF_RANGE
*/

CEXPORT_C CRYSError_t _DX_RSA_SCHEMES_Decrypt(CRYS_RSAUserPrivKey_t *UserPrivKey_ptr,
                                    CRYS_RSAPrimeData_t			    *PrimeData_ptr,
                                    CRYS_RSA_HASH_OpMode_t			hashFunc,
                                    DxUint8_t						*L,
                                    DxUint16_t						Llen,
                                    CRYS_PKCS1_MGF_t				MGF,
                                    DxUint8_t						*DataIn_ptr,
                                    DxUint16_t						DataInSize,
                                    DxUint8_t						*Output_ptr,
                                    DxUint16_t						*OutputSize_ptr,
                                    CRYS_PKCS1_version				PKCS1_ver)
{
 	return DX_HW_Dispatcher_ptr( DX_SEP_HOST_SEP_PROTOCOL_HOST_RSA_DEC_OP_CODE, 11,
	   							 /* PARAMETERS: */
								 UserPrivKey_ptr,
								 PrimeData_ptr,
								 hashFunc,
								 L, Llen, 
								 MGF,
								 DataIn_ptr, DataInSize,
								 Output_ptr, OutputSize_ptr,
								 PKCS1_ver );
   
}/* END OF _DX_RSA_SCHEMES_Decrypt */

#endif /*!defined(_INTERNAL_CRYS_NO_RSA_DECRYPT_SUPPORT) && !defined(_INTERNAL_CRYS_NO_RSA_SIGN_SUPPORT)*/




